/************************************************************************

file name   : iosc-devices.h
description : device number list used by iosc 
remark      : device number 162 is reserved for PCMCIA ?
date        : 2006/09/22 
Copyright   : Panasonic Corporation.

%Id: iosc-devices.h,v 1.19 2009/06/23 11:47:35 higu Exp $

 ************************************************************************/

#ifndef IOSC_DEVICES_H
#define IOSC_DEVICES_H

#include <dtvrecdd/devices_major.h>

/*** Common definition ***/
#define WRAP_MEM_ALIGNMENT 4
#ifndef FALSE
#define FALSE   (0)
#endif
#ifndef TRUE
#define TRUE    (1)
#endif
typedef int  boolean;
typedef void (*fp)(void);

#define IOSC_RX_TSD_PCR_THREAD_PRI 93
#define IOSC_INTR_THREAD_PRI   93
#define IOSC_RX_TSD_THREAD_PRI 87
#define IOSC_RX_VBI_THREAD_PRI 87
#define IOSC_RX_STM_THREAD_PRI 87
#define IOSC_RX_TSD_MEM_THREAD_PRI 84
#define IOSC_RX_RRL_THREAD_PRI 84
#define IOSC_RX_DEFAULT_THREAD_PRI 83
#define IOSC_RX_TCON_THREAD_PRI 83

typedef enum {
	ASN_L_PSI_F ,		/* PSI Filter responese event	*/
	ASN_L_MPI_F ,		/* PSI Filter responese event(V3)	*/
	ASN_L_SI_F ,		/* SI Filter response event	*/
	ASN_L_ONL_F ,		/* Online Filter response evnet	*/
	ASN_L_INP_F ,		/* input Filter response event	*/
	ASN_L_AVM_F ,		/* AV Manager response event	*/
	ASN_L_AUD_D ,		/* audio decoder response event	*/
	ASN_L_AUD_M ,		/* audio decoder response event	*/
	ASN_L_MVD_D,		/* video decoder response evnet	*/
	ASN_L_GFX_D ,		/* graphics decoder response event	*/
	ASN_L_MTD_F ,		/* tsd Filter response event(v3)	*/
	ASN_L_VDR ,		/* video decoder driver event	*/
	ASN_L_MAD_D ,		/* audio decoder driver event	*/
	ASN_L_MPA_D ,		/* audio decoder driver event(V3)	*/
	ASN_L_PCM_D ,		/* PCM driver event		*/
	ASN_L_MPV_D 		/* video decoder driver event(V3)	*/
} asn_t;

#define ASN_L_TSD_F ASN_L_MTD_F

typedef struct _asn_response_t {
	asn_t	event_t;
	short	reqid;
	short	code;		/* return: error status		*/
	void*	data;		/* return: pointer to real data	*/
} asn_response_t;

/* callback function for async report */
typedef void (*asn_notify_t)(asn_response_t msg);

/*  L_DEVNAME   = /dev/iosc/lXXXX   */
/*  R_DEVNAME   = /dev/iosc/rXXXX   */

#define DEVFS_PATH      "/dev/iosc"
#define L_DEVFS_PATH    DEVFS_PATH "/l"
#define R_DEVFS_PATH    DEVFS_PATH "/r"

#define L_DEVFILE( name )           L_DEVFS_PATH name
#define R_DEVFILE( name )           R_DEVFS_PATH name

#define MAX_MINOR_NUM   10   /* Max number of following definition */

/* Max minor number of each device */
//#define GFX_MINOR_NUM   3   /*0:control  1-2:user*/
#define ICC_MINOR_NUM   2   /*0:control  1-2:user*/
//#define VDX_MINOR_NUM   3   /*0:control  1-2:user*/
#define TSD_MINOR_NUM   9   /*0:control  1-2:user*/
#define MSS_MINOR_NUM   5   /*0:control  1-2:user*/
#define IPR_MINOR_NUM   5   /*0:control  1-4:user*/
//#define INP_MINOR_NUM   2   /*0:control  1-2:user*/
//#define RMT_MINOR_NUM   2   /*0:control  1-2:user*/
//#define SD_MINOR_NUM    2   /*0:control  1-2:user*/
//#define VBI_MINOR_NUM   2   /*0:control  1-2:user*/
//#define RRL_MINOR_NUM   3   /*0:control  1-2:user*/
#define OD_MINOR_NUM    3   /*0:control  1-2:user*/
#define TCON_MINOR_NUM  3   /*0:control  1-2:user*/
#define FRC_MINOR_NUM   3   /*0:control  1-2:user*/
#define VOUT_MINOR_NUM  3   /*0:control  1-2:user*/
#define EXIV_MINOR_NUM  6   /*0:control  1-5:user*/
#define ADECA_MINOR_NUM 6   /*0:control  1-2:user*/
#define VOP_MINOR_NUM   3   /*0:control  1-2:user*/
#define SYNC_MINOR_NUM  5   /*0-4:user*/

#define INT_DEV_MINOR_NUM 1

/* mmap base address of each device */
//#define GFX_MMAP_BASE   0
#define ICC_MMAP_BASE   0
//#define VDX_MMAP_BASE   0
#define TSD_MMAP_BASE   0
#define MSS_MMAP_BASE   0
#define IPR_MMAP_BASE   0
//#define INP_MMAP_BASE   0
//#define RMT_MMAP_BASE   0
//#define SD_MMAP_BASE    0
//#define VBI_MMAP_BASE   0
//#define RRL_MMAP_BASE   0
#define OD_MMAP_BASE    0
#define TCON_MMAP_BASE  0
#define FRC_MMAP_BASE   0
#define VOUT_MMAP_BASE  0
#define EXIV_MMAP_BASE  0
#define ADECA_MMAP_BASE 0
#define VOP_MMAP_BASE   0
#define SYNC_MMAP_BASE  0

/********************************************************** 
   moved XXX_MAJOR definition in devices_major.h
***********************************************************/
#define IOSC_MAX_DEV_MAJOR   (LOG_DEV_MAJOR + 1)


enum {
    L_GFX_MAGIC = 10,
    R_GFX_MAGIC,
    L_ICC_MAGIC,
    R_ICC_MAGIC,
    L_VDX_MAGIC,
    R_VDX_MAGIC,
    L_TSD_MAGIC,
    R_TSD_MAGIC,
    L_MSS_MAGIC,
    R_MSS_MAGIC,
	
    L_IPR_MAGIC, /* 20 */
    R_IPR_MAGIC,
    L_VBI_MAGIC,
    R_VBI_MAGIC,
    L_OD_MAGIC,
    R_OD_MAGIC,
    L_TCON_MAGIC,
    R_TCON_MAGIC,
    L_FRC_MAGIC,
    R_FRC_MAGIC,
	
    L_INP_MAGIC, /* 30 */
    R_INP_MAGIC,
    L_VOUT_MAGIC,
    R_VOUT_MAGIC,
    L_SEMDEV_MAGIC,
    L_INTDEV_MAGIC,
    L_EXIV_MAGIC,
    R_EXIV_MAGIC,
    L_ADECA_MAGIC,
    R_ADECA_MAGIC,

    L_VOP_MAGIC, /* 40 */
    R_VOP_MAGIC,
    L_SYNC_MAGIC,
    R_SYNC_MAGIC,
};

#endif /* IOSC_DEVICES_H */
